clear all
clc
close all
% Define Cell Parameters
Q = 2*3600; %2Ah capacity
Ct = 2700; %Double layer capacitance
Rt = 0.011; %SEI layer Charge transfer resistance
Rs = 0.008; %Cell internal resistance
Rd = 1e6; %Self-discharge resistor
SOC_0=0.5; %Initial SOC

%OCV Look-Up Table
V=[2.25 3.2 3.25 3.25 3.3 3.3 3.3 3.35 3.35 3.35 3.75];
SOC=[0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];

%Input Current Look-Up Table
t=0:0.1:70;
Load=[1 10 50;2 20 -50;3 30 0;4 40 100;5 50 -100;6 60 0;7 65 150;8 70 -150];
t1=0;
I=zeros(1,length(t));
for j=1:length(Load(:,1))
    ind=find(t>t1 & t<=Load(j,2));
    I(ind)=-Load(j,3);
    t1=t(ind(length(ind)));
end
sim('CellModel')
subplot(211)
plot(t,voltage.signals.values,'linewi',2)
xlabel('Time (s)')
ylabel('Voltage (V)')
box on
grid on
subplot(212)
plot(t,I,'linewi',2)
xlabel('Time (s)')
ylabel('Current (A)')
box on
grid on